<?php declare(strict_types=1);

namespace Addons\Integrations\Pusher\Listeners;

use Illuminate\Support\Facades\Config;
use SupportPal\Support\Json\Json;

use function array_merge;
use function e;
use function trans;
use function url;

class AddMetaConfig
{
    /**
     * @return mixed
     */
    public function hook()
    {
        $data = $this->data()->encode();
        if ($data !== false) {
            $data = e($data);
        }

        return <<<EOT
<meta name="pusher_config" content="$data" />
EOT;
    }

    private function data(): Json
    {
        return new Json([
            'key'    => Config::get('broadcasting.connections.pusher.key'),
            'params' => array_merge($this->defaultParams(), $this->serverParams()),
            'lang'   => [
                'unable_to_receive_updates' => trans('Integrations#Pusher::lang.unable_to_receive_updates'),
            ],
        ]);
    }

    /**
     * @return mixed[]
     */
    private function defaultParams(): array
    {
        return ['authEndpoint' => url('broadcasting/auth')];
    }

    /**
     * @return mixed[]
     */
    private function serverParams(): array
    {
        $params = [];
        $server = Config::get('broadcasting.connections.pusher.options');

        // set hosting type.
        $params['hosting'] = $server['hosting'] ?? '0';

        // https://beyondco.de/docs/laravel-websockets/basic-usage/pusher#usage-with-laravel-echo
        $params['wsHost'] = $server['external_host'] ?? null;
        $params['wsPort'] = $server['external_port'] ?? null;
        $params['forceTLS'] = $server['encryption'] ?? false;

        // pusher.com
        $params['cluster'] = $server['cluster'] ?? null;

        return $params;
    }
}
