<?php declare(strict_types=1);

namespace Addons\Integrations\Pusher\Listeners;

use App\Broadcasting\EchoConfig;
use Illuminate\View\View;
use SupportPal\Support\Json\Expr;

class OverwriteEchoConfig
{
    /**
     * @return void
     */
    public function compose(View $view)
    {
        /** @var EchoConfig $instance */
        $instance = $view->getData()['echoConfig'];
        $instance->setConfig([
            'broadcaster' => 'pusher',
            'client'      => new Expr('pusherClient'),
        ]);

        $view->with('echoConfig', $instance);
    }
}
