<?php declare(strict_types=1);

namespace Addons\Integrations\Pusher\Requests;

use App\Http\Requests\Request;
use Illuminate\Validation\Rules\In;

use function trans;

class SettingsRequest extends Request
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string,array>
     */
    public function rules(): array
    {
        return [
            'app_id'                    => ['integer', 'required_if:options.hosting,0'],
            'key'                       => ['required_if:options.hosting,0'],
            'secret'                    => ['required_if:options.hosting,0'],
            'options.hosting'           => ['required', new In([0, 1])],
            'options.cluster'           => ['required_if:options.hosting,0'],
            'options.host'              => ['string', 'required_if:options.hosting,1'],
            'options.port'              => ['integer', 'required_if:options.hosting,1'],
            'options.external_host'     => ['string'],
            'options.external_port'     => ['integer'],
            'options.encryption'        => ['boolean', 'required_if:options.hosting,1'],
        ];
    }

    /**
     * Get custom attributes for validator errors.
     *
     * @return array<string,string>
     */
    public function attributes(): array
    {
        return [
            'app_id'                => trans('Integrations#Pusher::lang.app_id'),
            'key'                   => trans('Integrations#Pusher::lang.key'),
            'secret'                => trans('Integrations#Pusher::lang.secret'),
            'options.hosting'       => trans('Integrations#Pusher::lang.hosting'),
            'options.cluster'       => trans('Integrations#Pusher::lang.cluster'),
            'options.host'          => trans('Integrations#Pusher::lang.internal_host'),
            'options.port'          => trans('Integrations#Pusher::lang.port'),
            'options.external_host' => trans('Integrations#Pusher::lang.external_host'),
            'options.external_port' => trans('Integrations#Pusher::lang.port'),
            'options.encryption'    => trans('Integrations#Pusher::lang.encryption'),
        ];
    }

    /**
     * Get custom messages for validator errors.
     *
     * @return array<string,string>
     */
    public function messages(): array
    {
        return [
            'app_id.required_if'             => trans('validation.required'),
            'key.required_if'                => trans('validation.required'),
            'secret.required_if'             => trans('validation.required'),
            'options.cluster.required_if'    => trans('validation.required'),
            'options.host.required_if'       => trans('validation.required'),
            'options.port.required_if'       => trans('validation.required'),
            'options.encryption.required_if' => trans('validation.required'),
        ];
    }
}
