;(function (window, document, Pusher) {
  function defaultHostname()
  {
    return window.location.hostname;
  }

  function defaultPort()
  {
    if (window.location.port === '') {
      return window.location.protocol === 'https:' ? 443 : 80;
    }

    return window.location.port;
  }

  // Read config.
  var config = document.querySelector('meta[name="pusher_config"]').getAttribute('content');
  config = JSON.parse(config);

  var params = {
    authEndpoint: config.params.authEndpoint,
    forceTLS: config.params.forceTLS,
    auth: {
      headers: {
        'X-CSRF-TOKEN': document.querySelector("meta[name='csrf_token']").getAttribute('content'),
      }
    }
  }

  if (config.params['hosting'] === "1") {
    params['wsHost'] = config.params.wsHost || defaultHostname()
    params['wsPort'] = config.params.wsPort || defaultPort()
    params['wssPort'] = config.params.wsPort || defaultPort()
    params['forceTLS'] = config.params.forceTLS === "1"
  } else {
    params['cluster'] = config.params.cluster
  }

  Pusher.log = (msg) => {
    console.log(msg);
  };

  window.pusherClient = new Pusher(config.key, params);

  var messageBox = document.getElementById('js-message-box'), element;
  if (messageBox) {
    element = messageBox.cloneNode(true);
    element.removeAttribute('id');
    messageBox.parentNode.insertBefore(element, messageBox.nextSibling);
  }

  var pusherError = function () {
    if (element) {
      element.classList.remove('sp-alert-success');
      element.classList.remove('sp-hidden');
      element.classList.add('sp-alert-error');
      element.innerHTML = '<i class="fas fa-fw fa-broadcast-tower"></i>&nbsp; ' + config.lang.unable_to_receive_updates;
    } else {
      console.error(config.lang.unable_to_receive_updates)
    }
  };

  pusherClient.connection.bind('state_change', function (states) {
    if (states.current === 'unavailable' || states.current === 'failed') {
      pusherError();
    } else if (element && states.previous === 'unavailable' && states.current === 'connected') {
      element.classList.add('sp-hidden');
    }
  });
  pusherClient.connection.bind('error', function (e) {
    console.error("Pusher client error", e);

    pusherError();
    setTimeout(function () {
      if (element) {
        element.classList.add('sp-hidden');
      }
    }, 10000);
  });
})(window, document, Pusher);
