<?php declare(strict_types=1);

/**
 * File SettingsRequest.php
 *
 * @copyright  Copyright (c) 2015-2020 SupportPal (http://www.supportpal.com)
 * @license    http://www.supportpal.com/company/eula
 */
namespace Addons\Integrations\Steam\Requests;

use App\Http\Requests\Request;
use Illuminate\Support\Facades\Lang;

/**
 * Class SettingsRequest
 */
class SettingsRequest extends Request
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules(): array
    {
        $rules = [];

        foreach (brand_config(null) as $brand) {
            $id = $brand->id;

            $rules['brand-settings.' . $id . '.client_id'] = ['nullable'];
        }

        return $rules;
    }

    /**
     * Get custom attributes for validator errors.
     *
     * @return array
     */
    public function attributes(): array
    {
        $attributes = [];

        foreach (brand_config(null) as $brand) {
            $id = $brand->id;

            $attributes['brand-settings.' . $id . '.client_id'] = Lang::get('Integrations#Steam::lang.api_key');
        }

        return $attributes;
    }
}
