<?php declare(strict_types=1);

namespace Addons\Integrations\Twilio\Factory;

use SupportPal\ProxyService\ProxyService;
use Twilio\Http\GuzzleClient;
use Twilio\Rest\Client;

class ClientFactory
{
    private ProxyService $proxyService;

    public function __construct(ProxyService $proxyService)
    {
        $this->proxyService = $proxyService;
    }

    public function create(string $sid, string $token): Client
    {
        $client = new Client($sid, $token);
        $client->setHttpClient(new GuzzleClient($this->proxyService->createGuzzle()));

        return $client;
    }
}
