<?php declare(strict_types=1);

namespace Addons\Integrations\Twilio\Requests;

use App\Http\Requests\Request;

use function sprintf;
use function trans;

class SettingsRequest extends Request
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return mixed[]
     */
    public function rules(): array
    {
        $rules = [];

        foreach (brand_config(null) as $brand) {
            $id = $brand->id;

            $rules['brand-settings.' . $id . '.account_sid'] = [
                'nullable',
                sprintf('required_with:brand-settings.%d.auth_token,brand-settings.%d.verify_sid', $id, $id),
            ];
            $rules['brand-settings.' . $id . '.auth_token'] = [
                'nullable',
                sprintf('required_with:brand-settings.%d.account_sid,brand-settings.%d.verify_sid', $id, $id),
            ];
            $rules['brand-settings.' . $id . '.api_secret'] = [
                'nullable',
                sprintf('required_with:brand-settings.%d.api_key', $id),
            ];
            $rules['brand-settings.' . $id . '.api_key'] = [
                'nullable',
                sprintf('required_with:brand-settings.%d.api_secret', $id),
            ];
        }

        return $rules;
    }

    /**
     * Get custom attributes for validator errors.
     *
     * @return mixed[]
     */
    public function attributes(): array
    {
        $attributes = [];

        foreach (brand_config(null) as $brand) {
            $id = $brand->id;

            $attributes['brand-settings.' . $id . '.account_sid'] = trans('Integrations#Twilio::lang.account_sid');
            $attributes['brand-settings.' . $id . '.auth_token'] = trans('Integrations#Twilio::lang.auth_token');
            $attributes['brand-settings.' . $id . '.api_key'] = trans('Integrations#Twilio::lang.api_key');
            $attributes['brand-settings.' . $id . '.api_secret'] = trans('Integrations#Twilio::lang.api_secret');
            $attributes['brand-settings.' . $id . '.verify_sid'] = trans('Integrations#Twilio::lang.verify_sid');
        }

        return $attributes;
    }
}
