<?php
/**
 * File Announcement.php
 *
 * @copyright  Copyright (c) 2015-2020 SupportPal (http://www.supportpal.com)
 * @license    http://www.supportpal.com/company/eula
 */
namespace Addons\Widgets\Announcements\Controllers;

use Illuminate\Support\Str;
use SimplePie_Item;

/**
 * Class Announcement
 */
class Announcement
{
    /**
     * Item from the RSS feed.
     *
     * @var SimplePie_Item
     */
    protected $item;

    /**
     * Announcement constructor.
     *
     * @param SimplePie_Item $item
     */
    public function __construct(SimplePie_Item $item)
    {
        $this->item = $item;
    }

    /**
     * Get the permalink for the item.
     *
     * @return string
     */
    public function permalink()
    {
        return htmlspecialchars_decode($this->item->get_permalink());
    }

    /**
     * Get the title of the item.
     *
     * @return string
     */
    public function title()
    {
        return htmlspecialchars_decode($this->item->get_title());
    }

    /**
     * Get the date of the item.
     *
     * @return string
     */
    public function date()
    {
        return formatDate($this->item->get_date('U'));
    }

    /**
     * Get the first 260 characters of the description.
     *
     * @param int $limit
     * @return string
     */
    public function description($limit = 260)
    {
        return Str::limit(htmlspecialchars_decode($this->item->get_description()), $limit);
    }
}
