<?php
/**
 * Announcements Widget
 *
 * @package    Addons\Widgets\Announcements\Controllers
 * @copyright  Copyright (c) 2015-2016 SupportPal (http://www.supportpal.com)
 * @license    http://www.supportpal.com/company/eula
 * @since      File available since Release 2.0.0
 */
namespace Addons\Widgets\Announcements\Controllers;

use App\Modules\Core\Controllers\Plugins\Plugin;
use App\Modules\Core\Controllers\Plugins\Widget;
use Config;
use Illuminate\Contracts\View\View as ViewContract;
use Illuminate\Support\Facades\Storage;
use SimplePie;
use SupportPal\ProxyService\ProxyService;
use View;

/**
 * Class Announcements
 *
 * @package    Addons\Widgets\Announcements\Controllers
 * @copyright  Copyright (c) 2015-2016 SupportPal (http://www.supportpal.com)
 * @license    http://www.supportpal.com/company/eula
 * @version    Release: @package_version@
 * @since      Class available since Release 2.0.0
 */
class Announcements extends Plugin implements Widget
{
    public function getEmbeddableView(): ?ViewContract
    {
        // Generate cache dir
        Storage::disk('local')->makeDirectory('rss_cache');
        $app_storage = Config::get('filesystems.disks.local.root', storage_path('app'));

        // Process the RSS Load
        $rss = app()->make(SimplePie::class);
        $rss->set_curl_options(app(ProxyService::class)->curlOpts());
        $rss->set_feed_url('https://www.supportpal.com/support/announcements/rss');
        $rss->set_cache_location($app_storage . DIRECTORY_SEPARATOR . 'rss_cache');
        $rss->init();
        $rss->handle_content_type();

        $announcements = [];
        foreach ((array) $rss->get_items(0, 2) as $announcement) {
            $announcements[] = new Announcement($announcement);
        }

        return View::make('Widgets#Announcements::view', ['announcements' => $announcements]);
    }

    /**
     * Plugins can run an installation routine when they are activated. This
     * will typically include adding default values, initialising database tables
     * and so on.
     *
     * @return mixed
     */
    public function activate()
    {
        return true;
    }

    /**
     * Deactivating serves as temporarily disabling the plugin, but the files still
     * remain. This function should typically clear any caches and temporary directories.
     *
     * @return mixed
     */
    public function deactivate()
    {
        return true;
    }

    /**
     * When a plugin is uninstalled, it should be completely removed as if it never
     * was there. This function should delete any created database tables, and any files
     * created outside of the plugin directory.
     *
     * @return mixed
     */
    public function uninstall()
    {
        return true;
    }
}
