<?php
/**
 * Getting Started Widget
 *
 * @package    Addons\Widgets\GettingStarted\Controllers
 * @copyright  Copyright (c) 2015-2016 SupportPal (http://www.supportpal.com)
 * @license    http://www.supportpal.com/company/eula
 * @since      File available since Release 2.0.0
 */
namespace Addons\Widgets\GettingStarted\Controllers;

use App\Modules\Core\Controllers\Plugins\Plugin;
use App\Modules\Core\Controllers\Plugins\Widget;
use App\Modules\Ticket\Models\Department as DepartmentModel;
use App\Modules\Ticket\Models\Ticket;
use Addons\Widgets\GettingStarted\Controllers\Steps\Brand;
use Addons\Widgets\GettingStarted\Controllers\Steps\CronJob;
use Addons\Widgets\GettingStarted\Controllers\Steps\Department;
use Addons\Widgets\GettingStarted\Controllers\Steps\GeneralSettings;
use Addons\Widgets\GettingStarted\Controllers\Steps\NewUser;
use Addons\Widgets\GettingStarted\Controllers\Steps\OpenTicket;
use Addons\Widgets\GettingStarted\Controllers\Steps\ReplyToTicket;
use Addons\Widgets\GettingStarted\Controllers\Steps\TicketChannels;
use Exception;
use Illuminate\Contracts\View\View as ViewContract;
use View;

use function route;
use function trans;

/**
 * Class GettingStarted
 *
 * @package    Addons\Widgets\GettingStarted\Controllers
 * @copyright  Copyright (c) 2015-2016 SupportPal (http://www.supportpal.com)
 * @license    http://www.supportpal.com/company/eula
 * @version    Release: @package_version@
 * @since      Class available since Release 2.0.0
 */
class GettingStarted extends Plugin implements Widget
{
    public function getEmbeddableView(): ?ViewContract
    {
        return View::make('Widgets#GettingStarted::view', ['steps' => self::getSteps()]);
    }

    /**
     * Get the list of getting started steps and their associated product tour stages.
     *
     * @return Step[]
     */
    public static function getSteps()
    {
        try {
            // Create route to the first department
            $department = DepartmentModel::firstOrFail();
            $deptRoute = route('ticket.operator.department.edit', [$department->id]);
        } catch (Exception $e) {
            $deptRoute = route('ticket.operator.department.create');
        }

        try {
            // Create route to the first ticket
            $ticket = Ticket::firstOrFail(['id']);
            $ticketRoute = route('ticket.operator.ticket.show', [$ticket->id]);
        } catch (Exception $e) {
            $ticketRoute = '';
        }

        return [
            new GeneralSettings(trans('core.general_settings'), route('core.operator.setting')),
            new Brand(trans('core.configure_brand'), route('core.operator.brand.index')),
            new Department(trans('core.configure_department'), $deptRoute),
            new CronJob(trans('core.setup_cron'), route('core.operator.scheduledtask.index')),
            new TicketChannels(trans('core.channel_settings'), route('ticket.operator.channel.index')),
            new NewUser(trans('core.add_user'), route('user.operator.user.create')),
            new OpenTicket(trans('core.open_ticket'), route('ticket.operator.ticket.createStep1')),
            new ReplyToTicket(trans('core.reply_ticket'), $ticketRoute),
        ];
    }

    /**
     * Plugins can run an installation routine when they are activated. This
     * will typically include adding default values, initialising database tables
     * and so on.
     *
     * @return mixed
     */
    public function activate()
    {
        return true;
    }

    /**
     * Deactivating serves as temporarily disabling the plugin, but the files still
     * remain. This function should typically clear any caches and temporary directories.
     *
     * @return mixed
     */
    public function deactivate()
    {
        return true;
    }

    /**
     * When a plugin is uninstalled, it should be completely removed as if it never
     * was there. This function should delete any created database tables, and any files
     * created outside of the plugin directory.
     *
     * @return mixed
     */
    public function uninstall()
    {
        return true;
    }
}
