<?php
/**
 * Getting Started Widget - Step
 *
 * @package    Addons\Widgets\GettingStarted\Controllers
 * @copyright  Copyright (c) 2015-2016 SupportPal (http://www.supportpal.com)
 * @license    http://www.supportpal.com/company/eula
 * @since      File available since Release 2.0.0
 */
namespace Addons\Widgets\GettingStarted\Controllers;

use ArrayAccess;

/**
 * Class Step
 *
 * @package    Addons\Widgets\GettingStarted\Controllers
 * @copyright  Copyright (c) 2015-2016 SupportPal (http://www.supportpal.com)
 * @license    http://www.supportpal.com/company/eula
 * @version    Release: @package_version@
 * @since      Class available since Release 2.0.0
 */
abstract class Step implements ArrayAccess
{
    /**
     * Configuration options, indexed by configuration key
     *
     * @var array
     */
    private $data = [];

    /**
     * Initialise a getting started step
     *
     * @param  string $name Name of the step
     * @param  string $url  URL to begin the step
     */
    public function __construct($name = '', $url = '')
    {
        $this->data = [
            'name' => $name,
            'url'  => $url,
        ];
    }

    /**
     * Determine whether a step has been completed.
     *
     * @return boolean
     */
    abstract public function isComplete();

    /**
     * Get a data by key
     *
     * @param  string $key The key data to retrieve
     * @return mixed empty string if the key doesn't exist
     */
    public function __get($key)
    {
        if ($key == 'complete') {
            return $this->isComplete();
        }

        return isset($this->data[$key]) ? $this->data[$key] : '';
    }

    /**
     * Assigns a value to the specified data
     *
     * @param  string $key   The data key to assign the value to
     * @param  mixed  $value The value to set
     */
    public function __set($key, $value)
    {
        $this->data[$key] = $value;
    }

    /**
     * Whether or not an data exists by key
     *
     * @param  string $key An data key to check for
     * @return boolean
     */
    public function __isset($key)
    {
        return isset($this->data[$key]);
    }

    /**
     * Unsets an data by key
     *
     * @param  string $key The key to unset
     */
    public function __unset($key)
    {
        unset($this->data[$key]);
    }

    /**
     * Assigns a value to the specified offset
     *
     * @param  string $offset The offset to assign the value to
     * @param  mixed  $value  The value to set
     */
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->data[] = $value;
        } else {
            $this->data[$offset] = $value;
        }
    }

    /**
     * Whether or not an offset exists
     *
     * @param  string $offset An offset to check for
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->data[$offset]);
    }

    /**
     * Unsets an offset
     *
     * @param  string $offset The offset to unset
     */
    public function offsetUnset($offset)
    {
        if ($this->offsetExists($offset)) {
            unset($this->data[$offset]);
        }
    }

    /**
     * Returns the value at specified offset
     *
     * @param  string $offset The offset to retrieve
     * @return mixed empty string if the key doesn't exist
     */
    public function offsetGet($offset)
    {
        if ($offset == 'complete') {
            return $this->isComplete();
        }

        return $this->offsetExists($offset) ? $this->data[$offset] : '';
    }
}
