<?php
/**
 * Getting Started Widget - Brand Step
 *
 * @package    Addons\Widgets\GettingStarted\Controllers\Steps
 * @copyright  Copyright (c) 2015-2016 SupportPal (http://www.supportpal.com)
 * @license    http://www.supportpal.com/company/eula
 * @since      File available since Release 2.1.0
 */
namespace Addons\Widgets\GettingStarted\Controllers\Steps;

use App\Modules\Core\Models\Brand as BrandModel;
use Addons\Widgets\GettingStarted\Controllers\Step;
use Config;
use Exception;

/**
 * Class Brand
 *
 * @package    Addons\Widgets\GettingStarted\Controllers\Steps
 * @copyright  Copyright (c) 2015-2016 SupportPal (http://www.supportpal.com)
 * @license    http://www.supportpal.com/company/eula
 * @version    Release: @package_version@
 * @since      Class available since Release 2.1.0
 */
class Brand extends Step
{
    /**
     * Determine whether a step has been completed.
     *
     * @return boolean
     */
    public function isComplete()
    {
        try {
            $installTime = Config::get('settings.install_time', time());

            return BrandModel::where('updated_at', '>', $installTime)->exists();
        } catch (Exception $e) {
            return false;
        }
    }
}
