<?php
/**
 * Getting Started Widget - New User Step
 *
 * @package    Addons\Widgets\GettingStarted\Controllers\Steps
 * @copyright  Copyright (c) 2015-2016 SupportPal (http://www.supportpal.com)
 * @license    http://www.supportpal.com/company/eula
 * @since      File available since Release 2.0.0
 */
namespace Addons\Widgets\GettingStarted\Controllers\Steps;

use App\Modules\User\Models\User;
use Addons\Widgets\GettingStarted\Controllers\Step;
use Exception;

/**
 * Class NewUser
 *
 * @package    Addons\Widgets\GettingStarted\Controllers\Steps
 * @copyright  Copyright (c) 2015-2016 SupportPal (http://www.supportpal.com)
 * @license    http://www.supportpal.com/company/eula
 * @version    Release: @package_version@
 * @since      Class available since Release 2.0.0
 */
class NewUser extends Step
{
    /**
     * Determine whether a step has been completed.
     *
     * @return boolean
     */
    public function isComplete()
    {
        try {
            // Check if a user exists (not operator)
            return User::user()->exists();
        } catch (Exception $e) {
            return false;
        }
    }
}
