<?php
/**
 * Getting Started Widget - Open Ticket Step
 *
 * @package    Addons\Widgets\GettingStarted\Controllers\Steps
 * @copyright  Copyright (c) 2015-2016 SupportPal (http://www.supportpal.com)
 * @license    http://www.supportpal.com/company/eula
 * @since      File available since Release 2.0.0
 */
namespace Addons\Widgets\GettingStarted\Controllers\Steps;

use App\Modules\Ticket\Models\Ticket;
use Addons\Widgets\GettingStarted\Controllers\Step;
use Exception;

/**
 * Class OpenTicket
 *
 * @package    Addons\Widgets\GettingStarted\Controllers\Steps
 * @copyright  Copyright (c) 2015-2016 SupportPal (http://www.supportpal.com)
 * @license    http://www.supportpal.com/company/eula
 * @version    Release: @package_version@
 * @since      Class available since Release 2.0.0
 */
class OpenTicket extends Step
{
    /**
     * Determine whether a step has been completed.
     *
     * @return boolean
     */
    public function isComplete()
    {
        try {
            return Ticket::exists();
        } catch (Exception $e) {
            return false;
        }
    }
}
