<?php
/**
 * Getting Started Widget - Reply To Ticket Step
 *
 * @package    Addons\Widgets\GettingStarted\Controllers\Steps
 * @copyright  Copyright (c) 2015-2016 SupportPal (http://www.supportpal.com)
 * @license    http://www.supportpal.com/company/eula
 * @since      File available since Release 2.0.0
 */
namespace Addons\Widgets\GettingStarted\Controllers\Steps;

use App\Modules\Ticket\Models\Message;
use App\Modules\Ticket\Models\Ticket;
use Addons\Widgets\GettingStarted\Controllers\Step;
use Exception;

/**
 * Class ReplyToTicket
 *
 * @package    Addons\Widgets\GettingStarted\Controllers\Steps
 * @copyright  Copyright (c) 2015-2016 SupportPal (http://www.supportpal.com)
 * @license    http://www.supportpal.com/company/eula
 * @version    Release: @package_version@
 * @since      Class available since Release 2.0.0
 */
class ReplyToTicket extends Step
{
    /**
     * Determine whether a step has been completed.
     *
     * @return boolean
     */
    public function isComplete()
    {
        try {
            // Find a message written by operator that isn't the first message on the ticket
            return Ticket::join('ticket_message', 'ticket.id', '=', 'ticket_message.ticket_id')
                ->where('ticket_message.user_id', auth_user()->id)
                ->where('ticket_message.type', Message::TYPE_MESSAGE)
                ->where('ticket_message.is_draft', 0)
                ->where('ticket.messages_count', '>', 1)
                ->exists();
        } catch (Exception $e) {
            return false;
        }
    }
}
