<?php
/**
 * Getting Started Widget - Ticket Channels Step
 *
 * @package    Addons\Widgets\GettingStarted\Controllers\Steps
 * @copyright  Copyright (c) 2015-2016 SupportPal (http://www.supportpal.com)
 * @license    http://www.supportpal.com/company/eula
 * @since      File available since Release 2.0.0
 */
namespace Addons\Widgets\GettingStarted\Controllers\Steps;

use App\Modules\Ticket\Models\ChannelAccount;
use App\Modules\Ticket\Models\ChannelSetting;
use Addons\Widgets\GettingStarted\Controllers\Step;
use Config;
use Exception;

/**
 * Class TicketChannels
 *
 * @package    Addons\Widgets\GettingStarted\Controllers\Steps
 * @copyright  Copyright (c) 2015-2016 SupportPal (http://www.supportpal.com)
 * @license    http://www.supportpal.com/company/eula
 * @version    Release: @package_version@
 * @since      Class available since Release 2.0.0
 */
class TicketChannels extends Step
{
    /**
     * Determine whether a step has been completed.
     *
     * @return boolean
     */
    public function isComplete()
    {
        try {
            $installTime = Config::get('settings.install_time', time());

            $exists = ChannelSetting::where('updated_at', '>', $installTime)->exists();
            if (! $exists) {
                return ChannelAccount::exists();
            }

            return $exists;
        } catch (Exception $e) {
            return false;
        }
    }
}
