<?php
/**
 * Notes Widget
 *
 * @package    Addons\Widgets\Notes\Controllers
 * @copyright  Copyright (c) 2015-2016 SupportPal (http://www.supportpal.com)
 * @license    http://www.supportpal.com/company/eula
 * @since      File available since Release 2.0.0
 */
namespace Addons\Widgets\Notes\Controllers;

use App\Modules\Core\Controllers\Plugins\Plugin;
use App\Modules\Core\Controllers\Plugins\Widget;
use App\Modules\User\Models\OperatorSetting;
use Illuminate\Contracts\View\View as ViewContract;
use Request;
use Response;
use View;

/**
 * Class Notes
 *
 * @package    Addons\Widgets\Notes\Controllers
 * @copyright  Copyright (c) 2015-2016 SupportPal (http://www.supportpal.com)
 * @license    http://www.supportpal.com/company/eula
 * @version    Release: @package_version@
 * @since      Class available since Release 2.0.0
 */
class Notes extends Plugin implements Widget
{
    public function getEmbeddableView(): ?ViewContract
    {
        // Get the operator ID
        $operator = auth_user();

        // Get the notes
        $notes = '';
        $settings = OperatorSetting::where('user_id', $operator->id)->first(['widget_notes']);

        // If exists and isn't empty, show the notes
        if (isset($settings) && ! empty($settings->widget_notes)) {
            $notes = $settings->widget_notes;
        }

        return View::make('Widgets#Notes::view', ['notes' => $notes]);
    }

    /**
     * Update the operator notes
     *
     * @return \Symfony\Component\HttpFoundation\Response
     */
    public function update()
    {
        // Get the operator ID
        $operator = auth_user();

        // Get the notes
        $notes = Request::all(['notes']);

        // Check it's valid and proceed
        if (isset($operator->id) && is_numeric($operator->id) && ! is_null($notes['notes'])) {
            $settings = OperatorSetting::where('user_id', $operator->id)->first();
            if (is_null($settings)) {
                return Response::json(['status' => 'error']);
            }

            // Update the notes
            $settings->widget_notes = $notes['notes'];

            // Save to the DB
            return $settings->save() ? Response::json(['status' => 'success']) : Response::json(['status' => 'error']);
        } else {
            return Response::json(['status' => 'error']);
        }
    }

    /**
     * Plugins can run an installation routine when they are activated. This
     * will typically include adding default values, initialising database tables
     * and so on.
     *
     * @return mixed
     */
    public function activate()
    {
        return true;
    }

    /**
     * Deactivating serves as temporarily disabling the plugin, but the files still
     * remain. This function should typically clear any caches and temporary directories.
     *
     * @return mixed
     */
    public function deactivate()
    {
        return true;
    }

    /**
     * When a plugin is uninstalled, it should be completely removed as if it never
     * was there. This function should delete any created database tables, and any files
     * created outside of the plugin directory.
     *
     * @return mixed
     */
    public function uninstall()
    {
        return true;
    }
}
