<?php
/**
 * Operator Login Log Widget
 *
 * @package    Addons\Widgets\OperatorLoginLog\Controllers
 * @copyright  Copyright (c) 2015-2016 SupportPal (http://www.supportpal.com)
 * @license    http://www.supportpal.com/company/eula
 * @since      File available since Release 2.0.0
 */
namespace Addons\Widgets\OperatorLoginLog\Controllers;

use App\Modules\Core\Controllers\Plugins\Plugin;
use App\Modules\Core\Controllers\Plugins\Widget;
use App\Modules\User\Models\OperatorLoginLog as OperatorLoginLogModel;
use Datatable;
use Illuminate\Contracts\View\View as ViewContract;
use Lang;
use View;

/**
 * Class OperatorLoginLog
 *
 * @package    Addons\Widgets\OperatorLoginLog\Controllers
 * @copyright  Copyright (c) 2015-2016 SupportPal (http://www.supportpal.com)
 * @license    http://www.supportpal.com/company/eula
 * @version    Release: @package_version@
 * @since      Class available since Release 2.0.0
 */
class OperatorLoginLog extends Plugin implements Widget
{
    public function getEmbeddableView(): ?ViewContract
    {
        $table = Datatable::table()
            ->addColumn(
                Lang::get('general.when'),
                Lang::get('general.name'),
                Lang::get('general.ip_address')
            )
            ->setUrl(route('widgets.operatorloginlog.table'))
            ->setOptions([
                'sDom'        => 'rt',
                'order'       => [[3, 'desc']],
                'columnDefs'  => [
                    ['targets' => 0, 'className' => 'all', 'orderable' => false],
                    ['targets' => 1, 'className' => 'min-tablet-p', 'orderable' => false],
                    ['targets' => 2, 'className' => 'desktop', 'orderable' => false],
                    ['targets' => 3, 'visible' => false]
                ]
            ])
            ->noScript();

        return View::make('Widgets#OperatorLoginLog::view', ['table' => $table]);
    }

    /**
     * DataTable json response.
     *
     * @return \Illuminate\Http\JsonResponse
     * @throws \Exception
     */
    public function dataTable()
    {
        $collection = OperatorLoginLogModel::with('user')
            ->orderBy('id', 'desc')
            ->take(5)
            ->get();

        return Datatable::collection($collection)
            ->addColumn('when', function (OperatorLoginLogModel $model) {
                return timeago($model->created_at);
            })
            ->addColumn('name', function (OperatorLoginLogModel $model) {
                return $model->formatName();
            })
            ->addColumn('ip', function (OperatorLoginLogModel $model) {
                return $model->ip;
            })
            ->addColumn('created_at', function (OperatorLoginLogModel $model) {
                return $model->created_at;
            })
            ->make();
    }

    /**
     * Plugins can run an installation routine when they are activated. This
     * will typically include adding default values, initialising database tables
     * and so on.
     *
     * @return mixed
     */
    public function activate()
    {
        return true;
    }

    /**
     * Deactivating serves as temporarily disabling the plugin, but the files still
     * remain. This function should typically clear any caches and temporary directories.
     *
     * @return mixed
     */
    public function deactivate()
    {
        return true;
    }

    /**
     * When a plugin is uninstalled, it should be completely removed as if it never
     * was there. This function should delete any created database tables, and any files
     * created outside of the plugin directory.
     *
     * @return mixed
     */
    public function uninstall()
    {
        return true;
    }
}
