<?php declare(strict_types=1);

namespace Addons\Widgets\Todo\Models;

use App\Modules\Core\Models\BaseModel;
use Illuminate\Database\Eloquent\SoftDeletes;

class Todo extends BaseModel
{
    use SoftDeletes;

    /**
     * Name of the table
     *
     * @var string
     */
    protected $table = 'operator_todo_widget';

    /**
     * Which fields are fillable
     *
     * @var array
     */
    protected $fillable = ['user_id', 'text', 'due'];

    /**
     * The attributes that should be cast to native types.
     *
     * @var array
     */
    protected $casts = [
        'user_id'    => 'int',
        'text'       => 'string',
        'due'        => 'int',
        'created_at' => 'int',
        'updated_at' => 'int',
        'deleted_at' => 'int',
    ];

    /**
     * Set the due time, with timezone offset handled.
     *
     * @param string $value
     * @return void
     */
    public function setDueAttribute($value)
    {
        $this->attributes['due'] = timeWithOffset(getTimestamp($value));
    }
}
