<?php declare(strict_types=1);

namespace Addons\Widgets\Todo\Requests;

use App\Http\Requests\Request;

class CreateOrUpdateRequest extends Request
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules(): array
    {
        return [
            'id'       => ['sometimes', 'required', 'exists:operator_todo_widget,id'],
            'text'     => ['sometimes', 'required', 'min:1'],
            'due'      => ['sometimes', 'required'],
        ];
    }
}
