<?php
/**
 * Widget Routes
 *
 * @package    Addons\Widgets\Todo\Routes
 * @copyright  Copyright (c) 2015-2016 SupportPal (http://www.supportpal.com)
 * @license    http://www.supportpal.com/company/eula
 * @since      File available since Release 2.0.0
 */

$router->post('add', [
    'as'   => 'widgets.todo.addTodo',
    'uses' => 'Addons\\Widgets\\Todo\\Controllers\\Todo@createOrUpdate'
]);

$router->post('mark/{id}', [
    'as'   => 'widgets.todo.mark',
    'uses' => 'Addons\\Widgets\\Todo\\Controllers\\Todo@mark'
])->where('id', '[0-9]+');

$router->delete('delete/{id}', [
    'as'   => 'widgets.todo.deleteTodo',
    'uses' => 'Addons\\Widgets\\Todo\\Controllers\\Todo@delete'
])->where('id', '[0-9]+');

$router->get('table', [
    'as'    => 'widgets.todo.table',
    'uses'  => 'Addons\\Widgets\\Todo\\Controllers\\Todo@dataTable'
]);
