$(document).ready(function() {

    /**
     * Reference to the table
     * @type {*|jQuery|HTMLElement}
     */
    var $widget = $('#todoWidget');

    /**
     * Add new record
     */
    $('#addNewTodo').on('click', function() {
        var route = $(this).data('route');

        Swal.fire({
            html:
                '<input name="add_todo_due" id="add_todo_due" type="text" class="datepicker sp-w-full" placeholder="&#xf073;" />' +
                '<input name="add_todo_text" id="add_todo_text" type="text" class="sp-mt-2 sp-w-full" placeholder="' + Lang.get('general.description') + '" />',
            showCancelButton: true,
            confirmButtonText: Lang.get('general.save'),
            showLoaderOnConfirm: true,
            didOpen: function () {
                $('#add_todo_due').datepicker();
            },
            preConfirm: function () {
                return $.post(route, { due: $('#add_todo_due').val(), text: $('#add_todo_text').val() })
                    .then(function (response) {
                        if (response.status === 'success') {
                            return response;
                        } else if (response.status === 'error') {
                            Swal.showValidationMessage(response.message);
                        } else {
                            throw new Error(response.statusText);
                        }
                    })
                    .catch(function () {
                        Swal.showValidationMessage(Lang.get('messages.error'));
                    });
            },
            allowOutsideClick: function () {
                return ! Swal.isLoading();
            }
        }).then(function (result) {
            if (result.value) {
                $widget.find('.dataTable').dataTable().api().ajax.reload();
            }
        });
    });

    /**
     * Editing a to-do entry
     */
    $widget.on('click', '.editTodo', function(e) {
        var route = $(this).data('route'),
            tr = $(this).parents('tr'),
            todoId = tr.data('id');

        Swal.fire({
            html: '<div class="sp-todo-widget-swal"></div>',
            showCancelButton: true,
            confirmButtonText: Lang.get('general.save'),
            showLoaderOnConfirm: true,
            didOpen: function () {
                $('.sp-todo-widget-swal')
                    .append(
                        $("<input>", {
                            type:'text',
                            id: 'edit_todo_due',
                            name: 'edit_todo_due',
                            class: 'datepicker sp-w-full',
                            placeholder: '&#xf073;',
                            value: tr.find('td:first').text()
                        })
                    )
                    .append(
                        $("<input>", {
                            type:'text',
                            id: 'edit_todo_text',
                            name: 'edit_todo_text',
                            class: 'sp-mt-2 sp-w-full',
                            value: tr.find('td:eq(1)').text()
                        })
                    );

                $('#edit_todo_due').datepicker();
            },
            preConfirm: function () {
                return $.post(route, { id: todoId, due: $('#edit_todo_due').val(), text: $('#edit_todo_text').val() })
                    .then(function (response) {
                        if (response.status === 'success') {
                            return response;
                        } else if (response.status === 'error') {
                            Swal.showValidationMessage(response.message);
                        } else {
                            throw new Error(response.statusText);
                        }
                    })
                    .catch(function () {
                        Swal.showValidationMessage(Lang.get('messages.error'));
                    });
            },
            allowOutsideClick: function () {
                return ! Swal.isLoading();
            }
        }).then(function (result) {
            if (result.value) {
                $widget.find('.dataTable').dataTable().api().ajax.reload();
            }
        });

    });

    /**
     * Mark a to-do item
     */
    $widget.on('click', '.markTodo', function(e) {

        var _self = this,
            tr = $(this).parents('tr'),
            todoId = tr.data('id'),
            route = $(_self).data('route') + '/' + todoId;

        // Disable the inputs and addTodoButton
        $(document.body).css({ 'cursor': 'wait' });

        $.post(route)
            .done(function( data ) {
                if (typeof data.status === 'undefined' || data.status !== 'success') {
                    $("#errorBoxToDo").text(data.message).fadeToggle(300).delay(5000).fadeToggle(300);
                    return;
                }

                $('#successBoxToDo').text(data.message).fadeToggle(300).delay(5000).fadeToggle(300);

                $widget.find('.dataTable').dataTable().api().ajax.reload();
            })
            .fail(function( data ) {
                $("#errorBoxToDo").text(data.message).fadeToggle(300).delay(5000).fadeToggle(300);
            })
            .always(function() {
                $(document.body).css({ 'cursor': 'default' });
            });
    });

});
