<?php

namespace Supportpal\HelpdeskBaseRequirements;

use Supportpal\HelpdeskBaseRequirements\Requirements\FilePermissions;
use Supportpal\HelpdeskBaseRequirements\Requirements\PhpExtensions;
use Supportpal\HelpdeskBaseRequirements\Requirements\PhpSettings;
use Supportpal\HelpdeskBaseRequirements\Requirements\PhpVersion;
use SupportPal\Requirements\RequirementGroup;

class PlatformRequirements
{
    /**
     * The keys of requirement groups.
     */
    const PHP_VERSION = 'phpVersion';
    const PHP_EXTENSIONS = 'phpExtensions';
    const PHP_SETTINGS = 'phpSettings';
    const FILE_PERMISSIONS = 'filePermissions';

    /**
     * Make all installer requirements.
     *
     * @return RequirementGroup[]
     */
    public static function make($basePath)
    {
        return array(
            self::PHP_VERSION      => self::phpVersion()->getRequirementGroup(),
            self::PHP_EXTENSIONS   => self::phpExtensions()->getRequirementGroup(),
            self::PHP_SETTINGS     => self::phpSettings()->getRequirementGroup(),
            self::FILE_PERMISSIONS => self::filePermissions($basePath)->getRequirementGroup(),
        );
    }

    private static function phpVersion()
    {
        return new PhpVersion;
    }

    private static function phpExtensions()
    {
        return new PhpExtensions;
    }

    private static function phpSettings()
    {
        return new PhpSettings;
    }

    private static function filePermissions($basePath)
    {
        return new FilePermissions($basePath);
    }
}
