<?php declare(strict_types=1);

/**
 * Condition Interface
 *
 * @package    SupportPal\Core\Database\Repositories\Conditions
 * @copyright  Copyright (c) 2015-2020 SupportPal (http://www.supportpal.com)
 * @license    http://www.supportpal.com/company/eula
 */
namespace SupportPal\Core\Database\Repositories\Conditions;

use Illuminate\Database\Eloquent\Builder;

/**
 * Interface ConditionInterface
 *
 * @package    SupportPal\Core\Database\Repositories\Conditions
 * @copyright  Copyright (c) 2015-2020 SupportPal (http://www.supportpal.com)
 * @license    http://www.supportpal.com/company/eula
 */
abstract class BaseCondition
{
    /**
     * Apply condition to query.
     *
     * @param Builder $query
     * @return Builder
     */
    abstract public function apply(Builder $query);
}
