<?php declare(strict_types=1);

/**
 * File OrderingHelpers.php
 *
 * @package    SupportPal\Core\Traits
 * @copyright  Copyright (c) 2015-2017 SupportPal (http://www.supportpal.com)
 * @license    http://www.supportpal.com/company/eula
 * @since      File available since Release 2.2.1
 */
namespace SupportPal\Core\Database\Traits;

use Illuminate\Database\Query\Builder;

/**
 * Trait OrderingHelpers
 *
 * @package SupportPal\Core\Traits
 */
trait OrderingHelpers
{
    /**
     * Clears the current ordering on the query.
     *
     * @param  Builder $query
     * @return Builder
     */
    public function scopeClearOrdering($query)
    {
        $query->getQuery()->orders = null;

        return $query;
    }
}
