<?php declare(strict_types=1);

/**
 * File SoftDeletes.php
 *
 * @package    SupportPal\Core\Database\Traits
 * @copyright  Copyright (c) 2015-2021 SupportPal (http://www.supportpal.com)
 * @license    http://www.supportpal.com/company/eula
 * @since      File available since Release 3.4.0
 */
namespace SupportPal\Core\Database\Traits;

use function array_keys;

trait SoftDeletes
{
    use \Illuminate\Database\Eloquent\SoftDeletes;

    /**
     * Perform the actual delete query on this model instance. Used to override the function in SoftDeletes trait.
     *
     * @return void
     */
    protected function runSoftDelete()
    {
        $query = $this->setKeysForSaveQuery($this->newModelQuery());

        $time = $this->fromDateTime($this->freshTimestamp());

        $columns = [$this->getDeletedAtColumn() => $time];

        $this->{$this->getDeletedAtColumn()} = $time;

        if ($this->timestamps && $this->getUpdatedAtColumn() !== null) {
            $this->{$this->getUpdatedAtColumn()} = $time;

            $columns[$this->getUpdatedAtColumn()] = $time;
        }

        $query->update($columns);

        $this->syncOriginalAttributes(array_keys($columns));
    }
}
