<?php declare(strict_types=1);

namespace SupportPal\Core\PhpRuntime;

use RuntimeException;

use function sleep;

class Clock
{
    public function sleep(int $seconds): int
    {
        $value = sleep($seconds);
        if ($value === false) {
            throw new RuntimeException('Sleep execution was interrupted.');
        }

        return $value;
    }
}
