<?php declare(strict_types=1);

namespace SupportPal\HelpdeskRequirements;

use Illuminate\Support\Facades\Config;
use Supportpal\HelpdeskBaseRequirements\PlatformRequirements;
use Supportpal\HelpdeskBaseRequirements\Requirements\AbstractRequirement;
use Supportpal\HelpdeskBaseRequirements\Requirements\FilePermissions;
use SupportPal\Requirements\Requirements as RequirementsList;

class FilePermissionRequirements extends AbstractRequirement
{
    public function getRequirementGroup()
    {
        $basePath = base_path();

        $appPath = Config::get('filesystems.disks.local.root', storage_path() . '/app');

        $directories = array(
            $basePath . '/config',
            $appPath,
            $appPath . '/attachments',
            $appPath . '/email_cache',
            $appPath . '/email_log',
            $appPath . '/exports',
            $appPath . '/public',
            $appPath . '/purifier_cache',
            $appPath . '/rss_cache',
            $appPath . '/selfservice',
            $appPath . '/session_locks',
            $appPath . '/swiftmailer_cache',
            $appPath . '/tickets',
            Config::get('cache.stores.file.path', storage_path() . '/framework/cache'),
            Config::get('session.files', storage_path() . '/framework/sessions'),
            Config::get('view.compiled', storage_path() . '/framework/views'),
            Config::get('app.log_path', storage_path() . '/logs'),
        );

        $group = RequirementsList::getInstance()->get(PlatformRequirements::FILE_PERMISSIONS);
        foreach ($directories as $directory) {
            $group->addRequiredRequirement(
                (new FilePermissions($basePath))->makeDirPermissionRequirement($directory)
            );
        }

        return $group;
    }
}
