<?php declare(strict_types=1);

namespace SupportPal\ProxyService\Config;

use Composer\CaBundle\CaBundle;

use function is_dir;

use const CURLOPT_CAINFO;
use const CURLOPT_CAPATH;
use const CURLOPT_PROXY;

class CurlConfig extends Config
{
    /**
     * @return mixed[]
     */
    public function toArray()
    {
        $opts = [];

        if ($this->config->hasUri()) {
            $opts[CURLOPT_PROXY] = $this->config->getUri();
        }

        $caPathOrFile = CaBundle::getSystemCaRootBundlePath();
        if (is_dir($caPathOrFile)) {
            $opts[CURLOPT_CAPATH] = $caPathOrFile;
        } else {
            $opts[CURLOPT_CAINFO] = $caPathOrFile;
        }

        return $opts;
    }
}
