<?php declare(strict_types=1);

namespace SupportPal\ProxyService;

use Illuminate\Contracts\Config\Repository;

class ProxyConfig
{
    private Repository $config;

    public function __construct(Repository $config)
    {
        $this->config = $config;
    }

    /**
     * Get proxy URI.
     *
     * @return mixed
     */
    public function getUri()
    {
        return $this->config->get('proxy.uri');
    }

    /**
     * Check whether a proxy is set.
     */
    public function hasUri(): bool
    {
        return ! empty($this->config->get('proxy.uri'));
    }
}
