<?php declare(strict_types=1);

namespace SupportPal\ProxyService;

use Illuminate\Support\ServiceProvider;
use SupportPal\ProxyService\Config\CurlConfig;
use SupportPal\ProxyService\Config\GuzzleConfig;
use SupportPal\ProxyService\Config\StreamConfig;

use function config_path;

class ProxyServiceProvider extends ServiceProvider
{
    /**
     * Register the service provider.
     *
     * @return void
     */
    public function register()
    {
        $this->mergeConfigFrom(__DIR__.'/../config/proxy.php', 'proxy');

        $this->app->singleton(ProxyService::class, function ($app) {
            return new ProxyService(
                $app->make(ProxyConfig::class),
                $app->make(GuzzleConfig::class),
                $app->make(CurlConfig::class),
                $app->make(StreamConfig::class),
                $app
            );
        });
    }

    /**
     * Register the resources that can be published using artisan.
     */
    protected function publishResources(): void
    {
        $this->publishes([
            __DIR__ . '/../../config/proxy.php' => config_path('proxy.php')
        ], 'proxy');
    }

    /**
     * Get the services provided by the provider.
     *
     * @return class-string[]
     */
    public function provides()
    {
        return [ProxyService::class];
    }
}
