<?php declare(strict_types=1);

namespace SupportPal\Support\Command;

use Exception;
use Illuminate\Contracts\Foundation\Application;
use RuntimeException;
use SupportPal\Support\Files\LockFile;
use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Output\OutputInterface;

use function trans;

/**
 * parent::xyz(); calls in this traits are risky, and confusing. Need to consider making it an abstract class later.
 */
trait WithoutOverlapping
{
    /**
     * Initializes the command just after the input has been validated.
     *
     * This is mainly useful when a lot of commands extends one main command
     * where some things need to be initialized based on the input arguments and options.
     *
     * @param  InputInterface  $input
     * @param  OutputInterface $output
     */
    protected function initialize(InputInterface $input, OutputInterface $output): void
    {
        $this->initializeMutex();

        parent::initialize($input, $output);
    }

    /**
     * Initialise a mutex.
     *
     * @throws RuntimeException
     */
    protected function initializeMutex(): void
    {
        $lockFile = $this->getLockFile();
        if (! $lockFile->acquire()) {
            throw new RuntimeException(trans('Support::general.locked_desc', ['path' => $lockFile->getPath()]));
        }
    }

    /**
     * Runs the command.
     *
     * The code to execute is either defined directly with the
     * setCode() method or by overriding the execute() method
     * in a sub-class.
     *
     * @return int The command exit code
     *
     * @throws Exception When binding input fails. Bypass this by calling {@link ignoreValidationErrors()}.
     *
     * @see setCode()
     * @see execute()
     */
    public function run(InputInterface $input, OutputInterface $output)
    {
        $exitCode = parent::run($input, $output);

        $this->getLockFile()->release();

        return $exitCode;
    }

    abstract protected function getLockFile(): LockFile;

    /**
     * Get the Laravel application instance.
     *
     * @return Application
     */
    abstract public function getLaravel();
}
