<?php declare(strict_types=1);

namespace SupportPal\Support\Files;

use SupportPal\Support\Exception\BinaryNotFoundException;
use Symfony\Component\Process\ExecutableFinder as SymfonyExecutableFinder;

class ExecutableFinder
{
    use ExecutableFinderConcerns;

    private SymfonyExecutableFinder $executableFinder;

    public function __construct(SymfonyExecutableFinder $executableFinder)
    {
        $this->executableFinder = $executableFinder;
    }

    /**
     * @throws BinaryNotFoundException
     */
    public function find(string $binaryName): string
    {
        $binaryPath = $this->executableFinder->find($binaryName);
        if ($binaryPath !== null) {
            return $binaryPath;
        }

        throw $this->binaryNotFoundException($binaryName);
    }
}
