<?php declare(strict_types=1);

namespace SupportPal\Support\Logging;

use Illuminate\Console\OutputStyle;
use SplSubject;

trait UsesLogger
{
    /**
     * The output interface implementation.
     *
     * @var OutputStyle
     */
    protected $output;

    public function update(SplSubject $subject): void
    {
        if (! ($subject instanceof Logger)) {
            return;
        }

        $this->output->writeln($subject->message());
    }
}
