<?php declare(strict_types=1);

namespace SupportPal\Support\Process;

use function function_exists;
use function posix_geteuid;
use function posix_getpwuid;

class Process
{
    public function getEffectiveUser(): ?string
    {
        if (! function_exists('posix_getpwuid') || ! function_exists('posix_geteuid')) {
            return null;
        }

        $userId = posix_geteuid();
        $pwuid = posix_getpwuid($userId);
        if ($pwuid === false) {
            return (string) $userId;
        }

        return $pwuid['name'] ?? null;
    }
}
