<?php declare(strict_types=1);

namespace SupportPal\Support\Str;

use function is_string;
use function preg_replace;

class RemoveAnsi
{
    public function removeAnsi(): callable
    {
        return function ($string): string {
            $value = preg_replace('/(\x9B|\x1B\[)[0-?]*[ -\/]*[@-~]/', '', $string);
            if (! is_string($value)) {
                return $string;
            }

            return $value;
        };
    }
}
