<?php declare(strict_types=1);

namespace SupportPal\Support\Utils;

use function str_replace;

use const PHP_OS_FAMILY;

class OSUtil
{
    public function isRunningOnWindows(): bool
    {
        return PHP_OS_FAMILY === 'Windows';
    }

    public function normalizeWindowsSeparators(string $path): string
    {
        return str_replace('\\', '/', $path);
    }
}
