<?php
/**
 * SupportPal Report File
 *
 * Quick Guide:
 * 1. Generate the required data by updating $report->query in all instances
 * 2. Update column headers in $data and then iterate through report data to add each row
 * 3. Update the 5 other variables with the information/options you require
 * 4. Save the file like NewReportName.php if you intend it to show as "New Report Name"
 */

// Use any models needed for data
use App\Modules\User\Models\User;

$report = new stdClass;

// Give the report a name and description
$report->title = Lang::get('report.user_by_country');
$report->description = Lang::get('report.user_by_country_desc');

// The report timeframe, possible options:
// monthly - allows selection of data for report for each month
// yearly  - allows selection of data for report for each year
// custom  - allows to choose any window of time for the report as well as all time, defaults to one month
//           from current date but can be overridden by setting $startDate and $endDate (UNIX timestamps)
// none    - for reports where time is not needed
$report->timeframe = 'none';

// The report chart options, an array with the following possible values, with the first value being shown by default:
// pie       - Pie chart, requires just two columns of data
// bar       - Bar chart, works with multiple columns of data
// column    - Column chart, works with multiple columns of data
// histogram - Histogram, requires just two columns of data
// line      - Line graph, requires three columns of data where one column is time-based
// area      - Area graph, requires three columns of data where one column is time-based
// stacked   - Stacked Area graph, similar to area graph but the various rows are stacked on top of each other
// stepped   - Stepped Area graph, similar to area graph but the various rows are stacked on top of each other
// geo       - Geo graph, requires just two columns of data where one is geographical-based
// table     - Table, visible on another tab
$report->charts = ['geo', 'table'];

// The report filtering options, either 'ticket' or 'user', or can be disabled by setting to null.
// ticket - Ticket specific options, requires use of the Ticket model
// user   - User specific options, requires use of the User model
$report->filtering = 'user';

// Setting out the initial query for the report data before any filtering is applied
$report->query = User::select(['user.country', DB::raw('count(DISTINCT user.id) AS `user_count`')])
    ->user()
    ->groupBy('user.country');

/**
 * Returns the data in a chart friendly format - use this to fetch the data and
 * convert it to a format that works with the report charts and tables.
 *
 * @param  Object $report The report data (above data with any custom additional data)
 * @param  mixed  $query  The query after filtering has been applied
 * @return  string           Json string of data
 */
function getData($report, $query)
{
    // Get list of countries
    $countries = countries();

    // Execute the query
    $result = $query->get()->toArray();

    // Start building returning data array
    $data = [];

    // Add the column headers
    $data[] = [Lang::get('user.country'), Lang::get('report.user_count')];

    // Add each row of data, ensure it matches the column header
    if (is_array($result)) {
        foreach ($result as $k => $v) {
            if (isset($countries[$v['country']])) {
                $data[] = [
                    e($countries[$v['country']]),
                    (int) $v['user_count']
                ];
            }
        }
    }

    // Reset array keys and encode it to JSON
    return json_encode(array_values($data));
}
