<?php

namespace App\Requirements;

use App\Requirements\Http\Request;

class Asset
{
    /** @var Request */
    private $request;

    /** @var string */
    private $basePath;

    /** @var bool */
    private $useMinified;

    public function __construct(Request $request)
    {
        $this->request = $request;
        $this->basePath = __DIR__.'/../..';
    }

    /**
     * @param string $path
     * @return string
     */
    public function link($path)
    {
        if ($this->useMinified === null && $this->isMinified($path)) {
            $this->useMinified = $this->exists($path);
        }

        if ($this->useMinified === false) {
            $path = str_replace(array('.min.css', '.min.js'), array('.css', '.js'), $path);
        }

        return $this->request->getBasePath() . $path;
    }

    /**
     * @param string $relative
     * @return string
     */
    private function absolutePath($relative)
    {
        return $this->basePath . '/' . ltrim($relative, '/');
    }

    /**
     * @param string $relative
     * @return bool
     */
    private function exists($relative)
    {
        return file_exists($this->absolutePath($relative));
    }

    /**
     * @param string $path
     * @return bool
     */
    private function isMinified($path)
    {
        return preg_match('/\.min\.[a-zA-Z]+$/', $path) === 1;
    }
}
