<?php

namespace App\Requirements;

use App\Requirements\Http\Request;
use Supportpal\HelpdeskBaseRequirements\Translator;
use SupportPal\Requirements\RequirementGroup;

class Template
{
    /**
     * @param RequirementGroup[] $requirements
     * @return void
     */
    public static function render(array $requirements)
    {
        $translator = Translator::getInstance()->guessLocale();
        $request = new Request($_SERVER);
        $asset = new Asset($request);

        if (! headers_sent()) {
            $protocol = (isset($_SERVER['SERVER_PROTOCOL']) ? $_SERVER['SERVER_PROTOCOL'] : 'HTTP/1.0');
            header(sprintf('%s 500 Internal Server Error', $protocol));
        }

        require_once __DIR__ . '/Views/pre_installation_check.php';

        exit(1);
    }
}
