<?php foreach ($requirements as $group) : ?>
    <div class="sp-requirement">
        <div class="sp-flex">
            <div class="sp-flex-none sp-requirement-status">
                <?php if ($group->allValid()) : ?>
                    <i class="fas fa-check-circle sp-text-green-600" aria-hidden="true"></i>
                <?php elseif ($group->requiredValid() && ! $group->optionalValid()) : ?>
                    <i class="fas fa-question-circle sp-text-orange-600" aria-hidden="true"></i>
                <?php else : ?>
                    <i class="fas fa-times-circle sp-text-red-600" aria-hidden="true"></i>
                <?php endif ?>
            </div>

            <div class="sp-flex-auto sp-requirement-details">
                <h2><?= $translator->translate($group->getName()) ?></h2>
                <div class="sp-is-valid"><?= $translator->translate($group->getMessage()) ?></div>
                <div class="sp-mt-2">
                    <a href="#" class="show-details">
                        <button class="sp-button-sm"><?= $translator->translate(new \SupportPal\Requirements\Translation\Translation('general.show_details')) ?></button>
                        <button class="sp-button-sm sp-hidden"><?= $translator->translate(new \SupportPal\Requirements\Translation\Translation('general.hide_details')) ?></button>
                    </a>
                </div>

                <div class="sp-hidden">
                    <?php $description = $group->getDescription() ?>
                    <?php if (! empty($description)) : ?>
                        <p class="sp-description"><?= $translator->translate($description) ?></p>
                    <?php endif ?>

                    <?php $my_groups = array('general.required' => $group->getRequired(), 'general.optional' => $group->getOptional()); ?>
                    <?php foreach ($my_groups as $name => $my_requirements) : ?>
                        <?php if (count($my_requirements) >= 1) : ?>
                            <h3><?= $translator->translate(new \SupportPal\Requirements\Translation\Translation($name)) ?></h3>
                            <table cellspacing="0" width="100%">
                                <?php foreach ($my_requirements as $requirement) : ?>
                                    <tr>
                                        <th><?= $translator->translate($requirement->getName()) ?></th>
                                        <td>
                                            <?php if (! $requirement->isValid()) : ?>
                                                <i class="fas fa-times sp-text-red-600" aria-hidden="true"></i>&nbsp;
                                                <?= $translator->translate($requirement->getFailureMsg()) ?>
                                            <?php else : ?>
                                                <i class="fas fa-check sp-text-green-600" aria-hidden="true"></i>&nbsp;
                                                <?= $translator->translate($requirement->getSuccessMsg()) ?>
                                            <?php endif; ?>
                                        </td>
                                    </tr>
                                <?php endforeach; ?>
                            </table>
                        <?php endif ?>
                    <?php endforeach; ?>
                </div>
            </div>
        </div>
    </div>
<?php endforeach;
