<?php
/**
 * File helpers.php
 *
 * @copyright  Copyright (c) 2015-2016 SupportPal (http://www.supportpal.com)
 * @license    http://www.supportpal.com/company/eula
 * @since      File available since Release 2.0.0
 */

if (! function_exists('colour_scheme')) {
    /**
     * Generate template theme CSS.
     *
     * @param  array $themes
     * @param  array $brandColors
     * @return string
     */
    function colour_scheme(array $themes, $brandColors = array())
    {
        // Override the light theme with the brand colours.
        // is_array check is here for BC. Pre 3.0, the brand colour config was a string, now it's an array.
        if (is_array($brandColors) && count($brandColors) > 0) {
            $themes['light']['scheme'] = array_merge($themes['light']['scheme'], $brandColors);
        }

        // Generate stylesheet.
        $styles = array();
        foreach ($themes as $name => $theme) {
            $style = "{$theme['selector']} {\n";
            foreach ($theme['scheme'] as $prop => $value) {
                $style .= "\t{$prop}: {$value};\n";
            }
            $style .= "}";

            $styles[] = $style;
        }

        // In print mode, dark mode should look like light mode.
        $style = "@media print {\n\t{$themes['dark']['selector']} {\n";
        foreach ($themes['light']['scheme'] as $prop => $value) {
            $style .= "\t\t{$prop}: {$value};\n";
        }
        $style .= "\t}\n}";

        $styles[] = $style;

        // Generate JavaScript.
        $jsThemes = array();
        foreach ($themes as $name => $theme) {
            $jsThemes[$name] = $theme['scheme'];
        }

        $html = "<style data-include>" . implode("\n\n", $styles) . "</style>\n";
        $html .= "<script>var spCssVarThemes = " . json_readable_encode($jsThemes) . "</script>";

        return $html;
    }
}

if (! function_exists('json_readable_encode')) {
    /**
     * This is intended to be a simple readable json encode function for PHP 5.3+ (licensed under GNU/AGPLv3 or GPLv3).
     * https://www.php.net/manual/en/function.json-encode.php#102091
     *
     * @param array $in
     * @param int   $indent
     * @param bool  $from_array
     * @return string
     */
    function json_readable_encode($in, $indent = 0, $from_array = false)
    {
        $_myself = __FUNCTION__;
        $_escape = function ($str) {
            return preg_replace("!([\b\t\n\r\f\"\\'])!", "\\\\\\1", $str);
        };

        $out = '';

        foreach ($in as $key => $value) {
            $out .= str_repeat("\t", $indent + 1);
            $out .= "\"" . $_escape((string) $key) . "\": ";

            if (is_object($value) || is_array($value)) {
                $out .= "\n";
                $out .= $_myself($value, $indent + 1);
            } elseif (is_bool($value)) {
                $out .= $value ? 'true' : 'false';
            } elseif (is_null($value)) {
                $out .= 'null';
            } elseif (is_string($value)) {
                $out .= "\"" . $_escape($value) ."\"";
            } else {
                $out .= $value;
            }

            $out .= ",\n";
        }

        if (! empty($out)) {
            $out = substr($out, 0, -2);
        }

        $out = str_repeat("\t", $indent) . "{\n" . $out;
        $out .= "\n" . str_repeat("\t", $indent) . "}";

        return $out;
    }
}
