<?php

if (! function_exists('return_bytes')) {
    /**
     * Convert human readable bytes to bytes.
     *
     * @param  string $size_str
     * @return int
     */
    function return_bytes($size_str)
    {
        // Handle shorthand notation: http://php.net/manual/en/faq.using.php#faq.using.shorthandbytes
        switch (substr($size_str, -1)) {
            case 'M':
            case 'm':
                return (int) $size_str * 1048576;

            case 'K':
            case 'k':
                return (int) $size_str * 1024;

            case 'G':
            case 'g':
                return (int) $size_str * 1073741824;

            default:
                // Handle integer bytes http://php.net/manual/en/ini.core.php#ini.memory-limit
                return $size_str;
        }
    }
}
