<?php

namespace SupportPal\Requirements\Translation;

class Translation
{
    /**
     * Translation key.
     *
     * @var string
     */
    protected $key;

    /**
     * Translation parameters.
     *
     * @var array
     */
    protected $params;

    /**
     * Translation constructor.
     *
     * @param  string $key
     * @param  array  $params
     */
    public function __construct($key, array $params = array())
    {
        $this->key = $key;
        $this->params = $params;
    }

    /**
     * Get the key.
     *
     * @return string
     */
    public function getKey()
    {
        return $this->key;
    }

    /**
     * Get the translation parameters.
     *
     * @return array
     */
    public function getParams()
    {
        return $this->params;
    }
}
