<?php

/*
 |-------------------------------------------------------------------------
 | Set server address.
 |-------------------------------------------------------------------------
 |
 | This is needed in order to lock the license when running the install:operator
 | command. This is the only time the license calls home when running from
 | console.
 |
 */

$_SERVER['SERVER_ADDR'] = '127.0.0.1';

/*
|--------------------------------------------------------------------------
| Create The Application
|--------------------------------------------------------------------------
|
| The first thing we will do is create a new Laravel application instance
| which serves as the "glue" for all the components of Laravel, and is
| the IoC container for the system binding all of the various parts.
|
*/
$app = new \App\Console\Application(
    $_ENV['HELPDESK_BASE_PATH'] ?? realpath(__DIR__ . '/../../')
);

/*
|--------------------------------------------------------------------------
| Bind Important Interfaces
|--------------------------------------------------------------------------
|
| Next, we need to bind some important interfaces into the container so
| we will be able to resolve them when needed. The kernels serve the
| incoming requests to this application from both the web and CLI.
|
*/

require __DIR__ . '/../bind_interfaces.php';

/*
|--------------------------------------------------------------------------
| Return The Application
|--------------------------------------------------------------------------
|
| This script returns the application instance. The instance is given to
| the calling script so we can separate the building of the instances
| from the actual running of the application and sending responses.
|
*/

return $app;
