<?php

use App\Providers\LicensingChannelServiceProvider;

return [

    /*
    |--------------------------------------------------------------------------
    | Application Name
    |--------------------------------------------------------------------------
    |
    | This value is the name of your application. This value is used when the
    | framework needs to place the application's name in a notification or
    | any other location as required by the application or its packages.
    |
    */

    'name' => env('APP_NAME', 'SupportPal'),

    /*
    |--------------------------------------------------------------------------
    | Application Environment
    |--------------------------------------------------------------------------
    |
    | The application environment enables you to override base configuration
    | items in ./config/*.php. This is useful for development purposes. The
    | environment defaults to production. This can be overridden using $_ENV.
    |
    */

    'env' => env('APP_ENV', 'production'),

    /*
    |--------------------------------------------------------------------------
    | Application Debug Mode
    |--------------------------------------------------------------------------
    |
    | When your application is in debug mode, detailed error messages with
    | stack traces will be shown on every error that occurs within your
    | application. If disabled, a simple generic error page is shown.
    |
    */

    'debug' => env('APP_DEBUG', false),

    /*
    |--------------------------------------------------------------------------
    | Application URL
    |--------------------------------------------------------------------------
    |
    | This URL is used by the console to properly generate URLs when using
    | the Artisan command line tool. You should set this to the root of
    | your application so that it is used when running Artisan tasks.
    |
    */

    'url' => 'http://localhost',

    'asset_url' => env('ASSET_URL', null),

    /*
    |--------------------------------------------------------------------------
    | Application Timezone
    |--------------------------------------------------------------------------
    |
    | Here you may specify the default timezone for your application, which
    | will be used by the PHP date and date-time functions. We have gone
    | ahead and set this to a sensible default for you out of the box.
    |
    */

    'timezone' => 'UTC',

    /*
    |--------------------------------------------------------------------------
    | Application Locale Configuration
    |--------------------------------------------------------------------------
    |
    | The application locale determines the default locale that will be used
    | by the translation service provider. You are free to set this value
    | to any of the locales which will be supported by the application.
    |
    */

    'locale' => 'en',

    /*
    |--------------------------------------------------------------------------
    | Application Fallback Locale
    |--------------------------------------------------------------------------
    |
    | The fallback locale determines the locale to use when the current one
    | is not available. You may change the value to correspond to any of
    | the language folders that are provided through your application.
    |
    */

    'fallback_locale' => 'en',

    /*
    |--------------------------------------------------------------------------
    | Faker Locale
    |--------------------------------------------------------------------------
    |
    | This locale will be used by the Faker PHP library when generating fake
    | data for your database seeds. For example, this will be used to get
    | localized telephone numbers, street address information and more.
    |
    */
    'faker_locale' => env('FAKER_LOCALE', 'en_US'),

    /*
    |--------------------------------------------------------------------------
    | Encryption Key
    |--------------------------------------------------------------------------
    |
    | This key is used by the Illuminate encrypter service and should be set
    | to a random, 32 character string, otherwise these encrypted strings
    | will not be safe. Please do this before deploying an application!
    |
    */

    'key' => 'SomeRandomStringSomeRandomString', // Not used

    'cipher' => 'AES-256-CBC',

    /*
    |--------------------------------------------------------------------------
    | Log Path
    |--------------------------------------------------------------------------
    |
    | Absolute path to directory where application logs are stored. The
    | directory must be writable by both your web server and CLI.
    |
    */

    'log_path' => storage_path().'/logs',

    /*
    |--------------------------------------------------------------------------
    | Autoloaded Service Providers
    |--------------------------------------------------------------------------
    |
    | The service providers listed here will be automatically loaded on the
    | request to your application. Feel free to add your own services to
    | this array to grant expanded functionality to your applications.
    |
    */

    'providers' => [

        /*
         * Laravel Framework Service Providers...
         */
        Illuminate\Auth\AuthServiceProvider::class,
        Illuminate\Broadcasting\BroadcastServiceProvider::class,
        Illuminate\Bus\BusServiceProvider::class,
        Illuminate\Cache\CacheServiceProvider::class,
        //Illuminate\Foundation\Providers\ConsoleSupportServiceProvider::class,
        Illuminate\Database\MigrationServiceProvider::class,
        Illuminate\Foundation\Providers\ComposerServiceProvider::class,
        Illuminate\Cookie\CookieServiceProvider::class,
        App\Providers\DatabaseServiceProvider::class,
        Illuminate\Encryption\EncryptionServiceProvider::class,
        App\Providers\FilesystemServiceProvider::class,
        Illuminate\Foundation\Providers\FoundationServiceProvider::class,
        Illuminate\Hashing\HashServiceProvider::class,
        Illuminate\Notifications\NotificationServiceProvider::class,
        Illuminate\Pagination\PaginationServiceProvider::class,
        Illuminate\Pipeline\PipelineServiceProvider::class,
        Illuminate\Queue\QueueServiceProvider::class,
        Illuminate\Redis\RedisServiceProvider::class,
        Illuminate\Auth\Passwords\PasswordResetServiceProvider::class,
        App\Providers\SessionServiceProvider::class,
        App\Providers\TranslationServiceProvider::class,
        Illuminate\Validation\ValidationServiceProvider::class,

        /*
         * Load these Package Service Providers before ours.
         */
        SupportPal\Pollcast\ServiceProvider::class,
        SupportPal\Support\ServiceProvider::class,
        TwigBridge\ServiceProvider::class,
        SupportPal\ProxyService\ProxyServiceProvider::class,
        SupportPal\OAuth\OAuthServiceProvider::class,
        Neves\Events\EventServiceProvider::class,

        /*
         * Application Service Providers...
         */
        App\Providers\ViewServiceProvider::class,
        App\Providers\DeferredServiceProvider::class,
        App\Providers\SettingServiceProvider::class,
        SupportPal\Marketplace\ClientServiceProvider::class,
        App\Providers\AddonServiceProvider::class,
        App\Providers\AppServiceProvider::class,
        App\Providers\EmailServiceProvider::class,
        App\Providers\AuthServiceProvider::class,
        App\Providers\EventServiceProvider::class,
        App\Providers\ModuleServiceProvider::class,
        App\Providers\BroadcastServiceProvider::class,
        App\Providers\PurifierServiceProvider::class,
        App\Providers\SamlServiceProvider::class,
        App\Providers\OAuthServiceProvider::class,
        App\Providers\ArtisanServiceProvider::class,
        App\Providers\HtmlServiceProvider::class,
        App\Providers\HorizonServiceProvider::class,
        App\Providers\HealthCheckProvider::class,
        App\Providers\PhoneVerifyServiceProvider::class,
        LicensingChannelServiceProvider::class,

        /*
         * Package Service Providers...
         */
        Chumper\Datatable\DatatableServiceProvider::class,
        Kodeine\Acl\AclServiceProvider::class,
        Proengsoft\JsValidation\JsValidationServiceProvider::class,
        JsLocalization\JsLocalizationServiceProvider::class,
        Lord\Laroute\LarouteServiceProvider::class,
        Intervention\Image\ImageServiceProvider::class,
        Fideloper\Proxy\TrustedProxyServiceProvider::class,
        Fruitcake\Cors\CorsServiceProvider::class,
        Propaganistas\LaravelPhone\PhoneServiceProvider::class,
        BeyondCode\LaravelWebSockets\WebSocketsServiceProvider::class,

    ],

    /*
    |--------------------------------------------------------------------------
    | Class Aliases
    |--------------------------------------------------------------------------
    |
    | This array of class aliases will be registered when this application
    | is started. However, feel free to register as many as you wish as
    | the aliases are "lazy" loaded so they don't hinder performance.
    |
    */

    'aliases' => [

        'App'       => Illuminate\Support\Facades\App::class,
        'Arr'       => Illuminate\Support\Arr::class,
        'Artisan'   => Illuminate\Support\Facades\Artisan::class,
        'Auth'      => Illuminate\Support\Facades\Auth::class,
        'Blade'     => Illuminate\Support\Facades\Blade::class,
        'Broadcast' => Illuminate\Support\Facades\Broadcast::class,
        'Bus'       => Illuminate\Support\Facades\Bus::class,
        'Cache'     => Illuminate\Support\Facades\Cache::class,
        'Config'    => Illuminate\Support\Facades\Config::class,
        'Cookie'    => Illuminate\Support\Facades\Cookie::class,
        'Crypt'     => Illuminate\Support\Facades\Crypt::class,
        'DB'        => Illuminate\Support\Facades\DB::class,
        'Eloquent'  => Illuminate\Database\Eloquent\Model::class,
        'Event'     => Illuminate\Support\Facades\Event::class,
        'File'      => Illuminate\Support\Facades\File::class,
        'Gate'      => Illuminate\Support\Facades\Gate::class,
        'Hash'      => Illuminate\Support\Facades\Hash::class,
        'Inspiring' => Illuminate\Foundation\Inspiring::class,
        'Lang'      => Illuminate\Support\Facades\Lang::class,
        'Log'       => Illuminate\Support\Facades\Log::class,
        'Mail'      => Illuminate\Support\Facades\Mail::class,
        'Notification' => Illuminate\Support\Facades\Notification::class,
        'Password'  => Illuminate\Support\Facades\Password::class,
        'Queue'     => Illuminate\Support\Facades\Queue::class,
        'Redirect'  => Illuminate\Support\Facades\Redirect::class,
        'Redis'     => Illuminate\Support\Facades\Redis::class,
        'Request'   => Illuminate\Support\Facades\Request::class,
        'Response'  => Illuminate\Support\Facades\Response::class,
        'Route'     => Illuminate\Support\Facades\Route::class,
        'Schema'    => Illuminate\Support\Facades\Schema::class,
        'Session'   => Illuminate\Support\Facades\Session::class,
        'Storage'   => Illuminate\Support\Facades\Storage::class,
        'Str'       => Illuminate\Support\Str::class,
        'URL'       => Illuminate\Support\Facades\URL::class,
        'Validator' => Illuminate\Support\Facades\Validator::class,
        'View'      => Illuminate\Support\Facades\View::class,

        /*
         * Custom
         */
        'Datatable'   => Chumper\Datatable\Facades\DatatableFacade::class,
        'Form'        => Collective\Html\FormFacade::class,
        'Html'        => Collective\Html\HtmlFacade::class,
        'Carbon'      => Carbon\Carbon::class,
        'Twig'        => TwigBridge\Facade\Twig::class,
        'JsValidator' => Proengsoft\JsValidation\Facades\JsValidatorFacade::class,
        'Image'       => Intervention\Image\Facades\Image::class,
        'SamlAuth'    => App\Modules\User\Controllers\Saml\Facades\SamlAuthManager::class,

        'Captcha'            => App\Modules\Core\Controllers\Captchas\Facades\CaptchaFactory::class,
        'LanguageFactory'    => App\Modules\Core\Controllers\Languages\Facades\LanguageFactory::class,
        'PluginFactory'      => App\Modules\Core\Controllers\Plugins\Facades\PluginFactory::class,
        'WidgetFactory'      => App\Modules\Core\Controllers\Plugins\Facades\WidgetFactory::class,
        'ChannelFactory'     => App\Modules\Ticket\Controllers\Channels\Facades\ChannelFactory::class,
        'Mailer'             => App\Modules\Core\Controllers\Mailer\Mailer::class,
        'TemplateView'       => App\Modules\Core\Controllers\Templates\Facade::class,
        'Purifier'           => SupportPal\Purifier\Facades\Purifier::class,
        'ConnectionPool'     => App\Modules\Core\Controllers\Mailer\Facade\ConnectionPool::class,
        'ReportFactory'      => App\Modules\Report\Facades\ReportFactory::class,

    ],

];
