<?php

return [

    /*
    |--------------------------------------------------------------------------
    | Address Headers
    |--------------------------------------------------------------------------
    |
    | Specify which headers contain addresses that should be parsed and
    | extracted. Array keys must be set in lowercase to the names of the
    | headers ending with a colon. A boolean value acts as enabled/disabled.
    |
    */

    'address_headers' => [
        'from:'         => 1, // DO NOT REMOVE
        'reply-to:'     => 1, // DO NOT REMOVE
        'to:'           => 1, // DO NOT REMOVE
        'delivered-to:' => 1,
        'envelope-to:'  => 1,
        'return-path:'  => 1,
        'cc:'           => 1, // DO NOT REMOVE
        'bcc:'          => 1, // DO NOT REMOVE
    ],

    /*
    |--------------------------------------------------------------------------
    | Destination Address Headers
    |--------------------------------------------------------------------------
    |
    | Specify which destination headers should be searched for a matching
    | department email address. Order matters!
    |
    | Any headers specified must also be specified in the "address_headers".
    |
    */

    'destination_headers' => [
        'to:'           => 1, // DO NOT REMOVE
        'cc:'           => 1, // DO NOT REMOVE
        'bcc:'          => 1, // DO NOT REMOVE
        'delivered-to:' => 1,
        'envelope-to:'  => 1,
    ],

    /*
    |--------------------------------------------------------------------------
    | Auto Reply Headers.
    |--------------------------------------------------------------------------
    |
    | List of headers that should be used to check for whether an inbound
    | email is an auto response. Cases which match will be imported but a
    | response won't be sent to them.
    |
    | The key of is name of the header (in lower case, including trailing colon).
    | The value is a regular expression to match against.
    |
    */

    'auto_reply_headers' => [
        'from:'                     => '/mailer-daemon@/i',
        'auto-submitted:'           => '/^((?!no).)*$/i',
        'precedence:'               => '/^auto_reply/i',
        'return-path:'              => '/^<>$/',
    ],

    /*
    |--------------------------------------------------------------------------
    | Email Commands
    |--------------------------------------------------------------------------
    |
    | Character sequence used to identify the start and end of an email command.
    | https://docs.supportpal.com/current/Email+Commands
    |
    */

    'macro_start_char' => '{%',

    'macro_end_char'   => '%}',

    /*
    |--------------------------------------------------------------------------
    | Hide Quoted Elements
    |--------------------------------------------------------------------------
    |
    | Whether to attempt to detect and hide quoted parts of inbound emails,
    | they will be wrapped in  [ ... ] and show/hide when clicked in the
    | operator ticket view.
    |
    */

    'toggle_quotes'    => true,

    /*
    |--------------------------------------------------------------------------
    | Cache Decay Time
    |--------------------------------------------------------------------------
    |
    | The time in minutes after which old cache files should be deleted. Cache
    | files are deleted automatically for emails that are parsed without error.
    | Cache files only remain if an error occurs to allow you to debug.
    |
    */

    'cache_decay'      => 60 * 48, // 2 Days.

    /*
    |--------------------------------------------------------------------------
    | IMAP batch size.
    |--------------------------------------------------------------------------
    |
    | The number of UNREAD emails to download per department email in a single
    | run of the scheduled task. Note, the length of time it takes to process
    | an email depends on its size (1 - 15+ seconds).
    |
    */

    'imap_batch'       => 50,

    /*
    |--------------------------------------------------------------------------
    | IMAP driver.
    |--------------------------------------------------------------------------
    |
    | There are two possible IMAP drivers:
    |   - 'php-imap' - PHP's IMAP extension.
    |   - 'horde'    - Horde's re-implementation of PHP's IMAP extension, which
    |                  offers new functionality such as OAuth connections and
    |                  proxy support.
    |
    */

    'imap_driver'     => 'horde',

    /*
    |--------------------------------------------------------------------------
    | imap_open parameters.
    |--------------------------------------------------------------------------
    |
    | Set imap_open connection parameters.
    | https://www.php.net/manual/en/function.imap-open.php
    |
    */

    'imap_open' => [

        // The number of seconds to wait before timing out the connection.
        // https://www.php.net/manual/en/function.imap-timeout.php
        'timeout'   => 5,

        // Options bitmask. See imap_open documentation.
        'options'   => 0,

        // Number of maximum connect attempts. See imap_open documentation.
        'n_retries' => 0,

        // Connection parameters. Accepts either an array (see imap_open
        // documentation) or an anonymous function that receives the
        // DepartmentEmail model as a parameter and returns an array.
        'params'    => array(),

    ],

    /*
    |--------------------------------------------------------------------------
    | Horde connection parameters.
    |--------------------------------------------------------------------------
    |
    | SupportPal offers two IMAP connection drivers. PHP's native IMAP extension
    | and Horde's re-implementation of ext-imap in PHP. Horde offers better
    | functionality and enables use of OAuth connections.
    |
    */

    'imap_horde' => [

        // A list of IMAP capabilities to ignore, even if they are supported on
        // the server.
        'capability_ignore'    => [],

        // Any context parameters passed to stream_create_context().
        // https://www.php.net/manual/en/context.php
        'context' => [
            'ssl' => [
                'verify_peer'       => false,
                'verify_peer_name'  => false,
                'allow_self_signed' => true
            ]
        ],

        // The number of seconds to wait before timing out the connection.
        'timeout'   => 30,

    ],

];
