<?php

return [

    /*
    |--------------------------------------------------------------------------
    | Define the languages you want exported messages for
    |--------------------------------------------------------------------------
    */

    'locales' => [],

    /*
    |--------------------------------------------------------------------------
    | Define the messages to export
    |--------------------------------------------------------------------------
    |
    | An array containing the keys of the messages you wish to make accessible
    | for the Javascript code.
    | Remember that the number of messages sent to the browser influences the
    | time the website needs to load. So you are encouraged to limit these
    | messages to the minimum you really need.
    |
    | Supports nesting:
    |   [ 'mynamespace' => ['test1', 'test2'] ]
    | for instance will be internally resolved to:
    |   ['mynamespace.test1', 'mynamespace.test2']
    |
    */

    'messages' => [
        'messages' => [
            'are_you_sure', 'yes_im_sure', 'deleted', 'success_deleted', 'error', 'error_deleted', 'warn_delete',
            'error_embed_image', 'please_correct', 'session_expired', 'session_refresh', 'save_order', 'no_results',
            'show_all_results', 'success_updated', 'success', 'error_updated', 'general_error', 'success_created',
            'error_created', 'error_loading_message', 'please_refresh', 'upload_error', 'upload_max_size',
            'upload_wrong_type', 'delete_record', 'keep_record', 'cannot_be_undone', 'delete_relations',
            'please_check', 'delete_confirm', 'failed_attachments', 'does_look_correct', 'no_revert', 'success_trashed',
            'error_trashed', 'datatable_error',
        ],
        'user' => [
            'user', 'search_for_user', 'select_operators', 'organisation', 'search_for_user',
            'select_user_groups', 'select_operator', 'select_operators', 'select_group', 'select_groups',
            'formatted_name', 'firstname', 'lastname', 'group', 'customfield', 'country',
            'search_for_user_operator', 'remove_from', 'remove_from_warn', 'unlink_account', 'unlink_account_warning',
            'account_active', 'confirmed', 'avatar', 'verify_phone_number', 'verify_phone_method',
            'verify_phone_code_sent',
        ],
        'general' => [
            'start', 'attachment', 'update', 'next', 'back', 'dismiss', 'operator', 'submit', 'save', 'loading',
            'add_attachment', 'message', 'record', 'text', 'preview', 'editor', 'manage', 'sort_by', 'frequently_used',
            'recently_used', 'recently_created', 'load_more', 'none', 'yes', 'no', 'na', 'id', 'name', 'email',
            'email_address', 'status', 'language', 'general', 'just_now', 'number', 'minutes_ago', 'hours_ago',
            'days_ago', 'weeks_ago', 'months_ago', 'years_ago', 'shortly', 'in_minutes', 'in_hours', 'in_days',
            'in_weeks', 'in_months', 'in_years', 'show_more', 'run', 'attachments', 'download', 'provider',
            'show_count_more', 'cancel', 'link', 'first', 'last', 'previous', 'description', 'sun', 'mon', 'tue', 'wed',
            'thu', 'fri', 'sat', 'sunday', 'monday', 'tuesday', 'wednesday', 'thursday', 'friday', 'saturday', 'jan',
            'feb', 'mar', 'apr', 'may', 'jun', 'jul', 'aug', 'sep', 'oct', 'nov', 'dec', 'january', 'february', 'march',
            'april', 'june', 'july', 'august', 'september', 'october', 'november', 'december', 'ordinal_th',
            'ordinal_st', 'ordinal_nd', 'ordinal_rd', 'range_separator', 'week_abbr', 'scroll_to_increment',
            'click_to_toggle', 'am', 'pm', 'year', 'hour', 'min', 'filter_results', 'any', 'today', 'yesterday',
            'last_7_days', 'last_30_days', 'this_month', 'last_month', 'url', 'close', 'merge',

            // hideShowPassword
            'show', 'hide',

            // yadcf
            'select_value', 'type_to_filter', 'from', 'to', 'select_a_date', 'select_values',
        ],
        'core' => [
            'welcome', 'welcome_desc', 'change_license', 'license_code', 'dashboard', 'dashboard_desc',
            'private_messages', 'messages_desc', 'configure', 'configure_desc', 'brand', 'brand_desc', 'brand_name',
            'brand_name', 'brand_name_desc', 'default_email', 'default_email_desc', 'department_desc',
            'department_email', 'dept_email_desc', 'dept_tmpl', 'dept_tmpl_desc', 'scheduled_task',
            'schedule_task_desc', 'schedule_task_cron', 'schedule_task_2', 'schedule_task_3', 'ticket_channel_desc',
            'ticket_channel', 'user_desc', 'organisation_desc', 'operator_desc', 'ticket_desc', 'ticket_desc2',
            'ticket_toolbar', 'ticket_desc3', 'tour_complete', 'tour_complete_desc', 'dept_settings_desc',
            'ticket_channel_2', 'add_remove_widget', 'twig_html_warning', 'select_brand', 'add_another_language',
            'twig_operator_reply_template', 'attachment_limit_reached', 'enable_ssl_warning', 'verify_frontend_loads',
            'web_settings_desc', 'search_results', 'token', 'plugins', 'widget', 'submit_ticket',

            // editor
            'insert_image', 'quote', 'code', 'format', 'paragraph', 'heading1', 'heading2', 'heading3', 'heading4',
            'heading5', 'heading6', 'upload', 'more_formatting', 'clearformat', 'bold', 'underline',
            'italic', 'strikethrough', 'font_color', 'insert_link', 'edit_link', 'unlink', 'orderedlist',
            'unorderedlist', 'outdent', 'indent', 'lists', 'edit_html', 'custom_colour', 'remove_colour',
            'background_colour', 'open_link', 'open_link_in', 'new_window', 'current_window', 'edit_image',
            'alternative_description', 'browse_image', 'drop_image', 'turquoise', 'green', 'blue', 'purple', 'navy_blue',
            'dark_turquoise', 'dark_green', 'medium_blue', 'medium_purple', 'midnight_blue', 'yellow', 'orange', 'red',
            'light_gray', 'gray', 'dark_yellow', 'dark_orange', 'dark_red', 'medium_gray', 'dark_gray', 'light_green',
            'light_yellow', 'light_red', 'light_purple', 'light_blue', 'dark_purple', 'dark_blue', 'black', 'white',

            // datatables
            'sEmptyTable', 'sInfo', 'sInfoEmpty', 'sInfoFiltered', 'sInfoPostFix', 'sInfoThousands', 'sLengthMenu',
            'sLoadingRecords', 'sProcessing', 'sSearchPlaceholder', 'sZeroRecords', 'sSortAscending', 'sSortDescending',

            // selectize
            'add_selectize',

            // shortcuts
            'keyboard_shortcuts', 'enable_keyboard_shortcuts', 'shortcut_global', 'shortcut_toggle',
            'shortcut_start_search', 'shortcut_goto_new_ticket', 'shortcut_ticket_view', 'shortcut_focus_reply',
            'shortcut_focus_notes', 'shortcut_focus_forward', 'shortcut_toggle_user_tab', 'shortcut_take_ticket',
            'shortcut_close_ticket', 'shortcut_lock_ticket', 'shortcut_unlock_ticket', 'shortcut_trash_ticket',
            'shortcut_block_user', 'shortcut_watch_ticket', 'shortcut_unwatch_ticket', 'shortcut_merge_ticket',
            'shortcut_unmerge_ticket', 'shortcut_expand_all', 'shortcut_collapse_all', 'shortcut_print_ticket',
        ],
        'ticket' => [
            'department', 'channel', 'ticket', 'search_canned', 'cannedresponse', 'search_selfservice',
            'add_selfservice_link', 'type_in_tags', 'assign_operator', 'also_viewing', 'take_ownership', 'set_status',
            'mass_reply', 'reply_options', 'block_warning', 'delete_warning', 'set_due_time', 'associate_response_tag',
            'tag', 'select_a_parent', 'select_a_department', 'subject', 'sla_plan', 'due_time',
            'created_time', 'last_action', 'last_message_text', 'assigned_operator', 'priority', 'send_email_to_users',
            'send_email_to_operators', 'create_new_user', 'convert_user_ticket_desc', 'enter_email_address',
            'department_template_disabled', 'run_macro', 'run_macro_desc', 'add_linked_ticket',
            'at_least_one_recipient', 'forwarded_message', 'from', 'web_settings', 'follow_up', 'older_messages',
            'follow_up_no_actions', 'merge_tickets', 'search_number_or_subject', 'merge_tickets_into', 'recent_tickets',
            'unresolved', 'resolved',
        ],
        'notification' => [
            'new_ticket', 'new_ticket_text'
        ],
        'selfservice' => [
            'associate_tag', 'associate_category', 'change_slug', 'thank_you_for_feedback',
        ],
        'validation' => [
            'required', 'embed_image',
            'max' => ['file', 'string'],
        ],
        'operator' => [
            'merge_fields', 'merge_fields_desc', 'strings', 'frontend_url', 'operator_url', 'collections',
            'merge_field_canned_desc',
        ],
        'report' => [
            'user_feedback'
        ],
        'Plugins#TimeTracking::lang' => [
            'time_tracking'
        ],
        'customfield' => [
            'select_option', 'date', 'customfield'
        ],
        'conditions' => [
            'ticket_custom_field', 'user_custom_field', 'user_organisation_custom_field',
        ]
    ],

    /*
    |--------------------------------------------------------------------------
    | Frontend keys.
    |--------------------------------------------------------------------------
    |
    | Define the subset of keys that should be available to the frontend.
    |
     */

    'frontend' => [
        'messages' => [
            'deleted', 'success_deleted', 'error', 'error_deleted', 'warn_delete', 'error_embed_image',
            'please_correct', 'error_loading_message', 'upload_error', 'upload_max_size', 'upload_wrong_type',
            'delete_record', 'delete_confirm', 'keep_record', 'cannot_be_undone', 'datatable_error', 'success',
            'general_error',
        ],
        'user' => [
            'user', 'organisation', 'remove_from', 'remove_from_warn', 'unlink_account', 'unlink_account_warning',
            'avatar', 'verify_phone_number', 'verify_phone_method', 'verify_phone_code_sent',
        ],
        'general' => [
            'attachment', 'loading', 'general', 'just_now', 'minutes_ago', 'hours_ago', 'days_ago', 'weeks_ago',
            'months_ago', 'years_ago', 'shortly', 'in_minutes', 'in_hours', 'in_days', 'in_weeks', 'in_months',
            'in_years', 'show_more', 'download', 'provider', 'yes', 'no', 'show_count_more', 'record', 'cancel', 'text',
            'first', 'last', 'next', 'previous', 'sun', 'mon', 'tue', 'wed', 'thu', 'fri', 'sat', 'sunday', 'monday',
            'tuesday', 'wednesday', 'thursday', 'friday', 'saturday', 'jan', 'feb', 'mar', 'apr', 'may', 'jun', 'jul',
            'aug', 'sep', 'oct', 'nov', 'dec', 'january', 'february', 'march', 'april', 'june', 'july', 'august',
            'september', 'october', 'november', 'december', 'ordinal_th', 'ordinal_st', 'ordinal_nd', 'ordinal_rd',
            'range_separator', 'week_abbr', 'scroll_to_increment', 'click_to_toggle', 'am', 'pm', 'year', 'hour', 'min',
            'save', 'dismiss', 'filter_results', 'any', 'status', 'show', 'hide', 'url', 'close', 'submit',
        ],
        'ticket' => [
            'enter_email_address', 'unresolved', 'resolved',
        ],
        'core' => [
            // editor
            'insert_image', 'quote', 'code', 'format', 'paragraph', 'heading1', 'heading2', 'heading3', 'heading4',
            'heading5', 'heading6', 'upload', 'more_formatting', 'clearformat', 'bold', 'underline',
            'italic', 'strikethrough', 'font_color', 'insert_link', 'edit_link', 'unlink', 'orderedlist',
            'unorderedlist', 'outdent', 'indent', 'lists', 'edit_html', 'submit_ticket', 'custom_colour', 'remove_colour',
            'background_colour', 'open_link', 'open_link_in', 'new_window', 'current_window', 'edit_image',
            'alternative_description', 'browse_image', 'drop_image', 'turquoise', 'green', 'blue', 'purple', 'navy_blue',
            'dark_turquoise', 'dark_green', 'medium_blue', 'medium_purple', 'midnight_blue', 'yellow', 'orange', 'red',
            'light_gray', 'gray', 'dark_yellow', 'dark_orange', 'dark_red', 'medium_gray', 'dark_gray', 'light_green',
            'light_yellow', 'light_red', 'light_purple', 'light_blue', 'dark_purple', 'dark_blue', 'black', 'white',

            // datatables
            'sEmptyTable', 'sInfo', 'sInfoEmpty', 'sInfoFiltered', 'sInfoPostFix', 'sInfoThousands', 'sLengthMenu',
            'sLoadingRecords', 'sProcessing', 'sSearchPlaceholder', 'sZeroRecords', 'sSortAscending', 'sSortDescending',

            // selectize
            'add_selectize',
        ],
        'selfservice' => [
            'thank_you_for_feedback',
        ],
        'validation' => [
            'required', 'embed_image',
            'max' => ['file'],
        ],
    ],

    /*
    |--------------------------------------------------------------------------
    | Set the keys of config properties you want to use in javascript.
    | Caution: Do not expose any configuration values that should be kept privately!
    |--------------------------------------------------------------------------
    */
    'config' => [
        //
    ],

    /*
    |--------------------------------------------------------------------------
    | Disables the config cache if set to true, so you don't have to
    | run `php artisan js-localization:refresh` each time you change configuration files.
    | Attention: Should not be used in production mode due to decreased performance.
    |--------------------------------------------------------------------------
    */
    'disable_config_cache' => false,

];
