<?php

return [

    /*
     * The destination path for the javascript file.
     */
    'path' => 'resources/assets/general/js',

    /*
     * The destination filename for the javascript file.
     */
    'filename' => 'routes',

    /*
     * The namespace for the helper functions. By default this will bind them to
     * `window.laroute`.
     */
    'namespace' => 'laroute',

    /*
     * Generate absolute URLs.
     *
     * Set the Application URL in config/app.php
     *
     * This setting must be set to true otherwise it causes issues when the application
     * is installed to a directory (not a sub-domain).
     */
    'absolute' => true,

    /*
     * The Filter Method
     *
     * 'all' => All routes except "'laroute' => false"
     * 'only' => Only "'laroute' => true" routes
     * 'force' => All routes, ignored "laroute" route parameter
     */
    'filter' => 'only',

    /*
     * Controller Namespace
     *
     * Set here your controller namespace (see RouteServiceProvider -> $namespace) for cleaner action calls
     * e.g. 'App\Http\Controllers'
     */
    'action_namespace' => '',

    /*
     * The path to the template `laroute.js` file. This is the file that contains
     * the ported helper Laravel url/route functions and the route data to go
     * with them.
     */
    'template' => 'vendor/supportpal/laroute/src/templates/laroute.js',
    
    /*
     * Appends a prefix to URLs. By default the prefix is an empty string.
    *
    */
    'prefix' => '',

];
