<?php

use Monolog\Handler\StreamHandler;
use Monolog\Handler\SyslogUdpHandler;

return [

    /*
    |--------------------------------------------------------------------------
    | Default Log Channel
    |--------------------------------------------------------------------------
    |
    | This option defines the default log channel that gets used when writing
    | messages to the logs. The name specified in this option should match
    | one of the channels defined in the "channels" configuration array.
    |
    */

    'default' => env('LOG_CHANNEL', 'stack'),

    /*
    |--------------------------------------------------------------------------
    | Deprecations Log Channel
    |--------------------------------------------------------------------------
    |
    | This option controls the log channel that should be used to log warnings
    | regarding deprecated PHP and library features. This allows you to get
    | your application ready for upcoming major versions of dependencies.
    |
    */

    'deprecations' => env('LOG_DEPRECATIONS_CHANNEL', 'stack'),

    /*
    |--------------------------------------------------------------------------
    | Log Channels
    |--------------------------------------------------------------------------
    |
    | Here you may configure the log channels for your application. Out of
    | the box, Laravel uses the Monolog PHP logging library. This gives
    | you a variety of powerful log handlers / formatters to utilize.
    |
    | Available Drivers: "single", "daily", "slack", "syslog",
    |                    "errorlog", "monolog",
    |                    "custom", "stack"
    |
    */

    'channels' => [
        'stack' => [
            'driver'    => 'stack',
            'channels'  => ['generallog'],
            'ignore_exceptions' => false,
        ],

        'slack' => [
            'driver'    => 'slack',
            'url'       => env('LOG_SLACK_WEBHOOK_URL'),
            'username'  => 'Laravel Log',
            'emoji'     => ':boom:',
            'level'     => 'critical',
        ],

        'papertrail' => [
            'driver' => 'monolog',
            'level' => 'error',
            'handler' => SyslogUdpHandler::class,
            'handler_with' => [
                'host' => env('PAPERTRAIL_URL'),
                'port' => env('PAPERTRAIL_PORT'),
            ],
        ],

        'stderr' => [
            'driver'  => 'monolog',
            'handler' => StreamHandler::class,
            'formatter' => env('LOG_STDERR_FORMATTER'),
            'with' => [
                'stream' => 'php://stderr',
            ],
        ],

        'syslog' => [
            'driver'    => 'syslog',
            'level'     => 'error',
        ],

        'errorlog' => [
            'driver'    => 'errorlog',
            'level'     => 'error',
        ],

        'emaillog' => [
            'driver'    => 'custom',
            'via'       => \App\Logging\EmailLogger::class,
            'max_files' => 5,
            'level'     => 'info'
        ],

        'generallog' => [
            'driver'    => 'custom',
            'via'       => \App\Logging\GeneralLogger::class,
            'max_files' => 5,
            'level'     => 'error'
        ],
        'test' => [
            'driver'    => 'custom',
            'via'       => \App\Logging\TestLogger::class,
        ]
    ],

];
